<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Routing\Router;

class MembersController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
   public function index(){
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			
			$orderby = ['Members.LastName' => $columnSortOrder];
				
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = [
					'OR' => [
						['Members.LastName LIKE' => '%'.$searchValue.'%'],
						['Members.FirstName LIKE' => '%'.$searchValue.'%']
					]
				];							
			}
			
			$where[] = ['Members.id >' => 0];
			
			$q1 = $this->Members->find()
					->where($where)
					->contain([])
					->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$datas = $this->Members->find()
					->where($where)
					->contain([])
					->order($orderby);
			}else{	
				$datas = $this->Members->find()
					->where($where)
					->contain([])
					->order($orderby)
					->limit($rowperpage)
					->offset($row);
			}
			
			
			if(!empty($datas)):
				foreach($datas as $u):
					$_link = Router::url(
						['controller' => 'members', 'action' => 'view', $u->id]
					);
					
					$link = '<a href="'.$_link.'" 
					title ="Account Details" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "modal_view dropdown-item"><div class="preview-thumbnail">View</div></a>';
					
					$view_link = '<a href="'.$_link.'" 
					title ="Account Details" 
					class = "dropdown-item btn btn-xs btn-outline-success"><div class="preview-thumbnail">
					<i class="typcn typcn-eye menu-icon"></i> View Details</div></a>';
					
					$link2 = '<a href="'.$_link.'" 
					title ="Member Profile" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item modal_view text-black bold">'.$u->name.'</a>';
					
					$update_link = Router::url(
						['controller' => 'members', 'action' => 'edit', $u->id]
					);
					
					$update_link = '<a href="'.$update_link.'" 
					title ="Update Account" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-edit menu-icon"></i> Make Changes</div></a>';
					
					$reassign = Router::url(
						['controller' => 'users', 'action' => 'edit', $u->id, "reassign"]
					);
					
					$reassign = '<a href="'.$reassign.'" 
					title ="Change Account Role" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-user menu-icon"></i> Change Role</div></a>';

					$actions = $view_link . $update_link;
					
					$act = '      <div class="dropdown">
                          <button class="btn btn-outline-info btn-sm dropdown-toggle" type="button" id="dropdownMenuIconButton6" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="typcn typcn-lock-closed"></i>
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuIconButton6">
                           
                           '.$actions.'
                          </div>
                        </div>';
						
				   $_data[] = array( 
						'fname'				=> '<span class="bold">'.$u->FirstName.'</span>',
						'mname'				=> $u->MI,
						'lname'				=> '<span class="bold">'.$u->LastName.'</span>',						
						'sex'				=> $u->Sex,
						'civil'				=> '<span class="bold text-uppercase">'.$u->CivilStatus.'</span>',
						'status'			=> '<span class="bold '.($u->Status=="ACTIVE" ? "text-black" : "text-danger").'">'.$u->Status.'</span>',
						'office'			=> '<span class="bold text-success">'.$u->Office.'</span>',
						'applied'			=> !empty($u->DateApplied) ? $u->DateApplied : "-",						
						'action'			=> $act
					);
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}
		
	
	public function selectmember($type=null, $show_list=null){
		$this->set('type', $type);
		if($this->request->is('ajax') && $show_list=="1"){
			//$link = json_decode(base64_decode($link));		
			$this->ajaxLayout();
			$_data 	= array();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			
			$orderby = ['Members.LastName' => $columnSortOrder];
				
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = [
					'OR' => [
						['Members.LastName LIKE' => '%'.$searchValue.'%'],
						['Members.FirstName LIKE' => '%'.$searchValue.'%']
					]
				];							
			}
			
			$where[] = ['Members.id >' => 0];
			
			$q1 = $this->Members->find()
					->where($where)
					->contain([])
					->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$datas = $this->Members->find()
					->where($where)
					->contain([])
					->order($orderby);
			}else{	
				$datas = $this->Members->find()
					->where($where)
					->contain([])
					->order($orderby)
					->limit($rowperpage)
					->offset($row);
			}
			
			$base_link = [];
			switch($type){
				case "loan-application":
					$base_link = ['controller' => 'loanmasters', 'action' => 'add'];
					$title = "Loan Application Details";
				break;
				default:
					$base_link = ['controller' => 'loanmasters', 'action' => 'add'];
					$title = '';
				break;
			}
					
			
			if(!empty($datas)):
				foreach($datas as $u):
				
					$link 		= $base_link;
					$link[] 	= $u->id; 
					$link[] 	= $type;
		
					$_link = Router::url($link);
					
					$link = '<a href="'.$_link.'" 
					title ="'.$title.'" 
					data-toggle = "modal" 
					data-target = "#view_modal_lg"
					style="width: 80px !important" 
					class = "modal_view_lg btn btn-xs btn-success">
					<i class="typcn typcn-user menu-icon"></i> Select</a>';
					
					
					
					
				   $_data[] = array( 
						'fname'				=> '<div class="bold" style="width: 130px !important;">'.$u->FirstName.'</div>',
						'mname'				=> '<div class="bold" style="width: 50px !important;">'.$u->MI.'</div>',
						'lname'				=> '<div class="bold" style="width: 130px !important;">'.$u->LastName.'</div>',						
						//'sex'				=> $u->Sex,						
						//'status'			=> '<span class="bold text-'.($u->Status=="ACTIVE" ? 'success' : 'danger').'">'.$u->Status.'</span>',						
						//'office'			=> '<span class="bold text-black">'.$u->Office.'</span>',				
						'action'			=> $u->Status=="ACTIVE" ? $link : "--"
					);
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}
	
	public function view(){
		$user	= $this->getCurrentUser();
		$id 	= $user['id'];
		
		  $user = $this->Members->Users->get($id, [
            'contain' => ['Members'],
        ]);
		
		 $member = $this->Members->find()
		->contain(['Membercapitalbuildups', 'Loanmasters'])
		->where(['Members.id' => $user->member->id])
		->first();

		
		$this->set(compact('member'));
		$this->set('img', $this->imagedir('url'));
		
	}
	
	
	
	public function myprofile($type=null, $id=null){
		
		
		switch($type){
			case "personal":
				$member = $this->Members->get($id, [
					'contain' => [],
				]);
			break;
			case "loans":
				$member = $this->Members->get($id, [
					'contain' => ['Loanmasters' => ['Loandetails']],
				]);
			break;
			case "childrens":
				$member = $this->Members->get($id, [
					'contain' => ['Memberschildrens'],
				]);
			break;
			case "payments":
				$member = $this->Members->get($id, [
					'contain' => ['Loanmasters' => ['Transactionmasters']],
				]);
			break;
			case "access":
				$member = $this->Members->get($id, [
					'contain' => ['Users'],
				]);
			break;
			case "deductions":
				$member = $this->Members->get($id, [
					'contain' => ['Monthlydeductions'],
				]);
			break;
			default:
				$member = $this->Members->get($id, [
					'contain' => [],
				]);
			break;
		}
		
		$this->set(compact('member', 'type'));
	}
	
	
	

   
}
