<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Routing\Router;

class PositionsController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
   public function index(){
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			switch($columnName){
				case "NAME":
					$orderby = ['Positions.name' => $columnSortOrder];
				break;
				default:
					$orderby = ['Positions.name' => $columnSortOrder];
				break;
			}
			
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = ['Positions.name LIKE' => '%'.$searchValue.'%'];
			}
			
			
			$where[] = ['Positions.id >' => 1];
			
			$q1 		= $this->Positions->find()
							->where($where)
							->contain([])
							->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$datas = $this->Positions->find()
					->where($where)
					->contain([])
					->order($orderby);
			}else{	
				$datas = $this->Positions->find()
					->where($where)
					->contain([])
					->order($orderby)
					->limit($rowperpage)
					->offset($row);
			}
			
			$total_sales = 0;
			if(!empty($datas)):
				foreach($datas as $u):
					
					$total_sales = "0.00";
					
										
					$_link = Router::url(
						['controller' => 'users', 'action' => 'view-user-profile/'.$u->id]
					);
					
					$link = '<a href="'.$_link.'" 
					title ="Account Details" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "modal_view dropdown-item"><div class="preview-thumbnail">View</div></a>';
					
					$view_link = '<a href="'.$_link.'" 
					title ="Account Details" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-eye menu-icon"></i> View Details</div></a>';
					
					$link2 = '<a href="'.$_link.'" 
					title ="Member Profile" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item modal_view text-black bold">'.$u->name.'</a>';
					
					$update_link = Router::url(
						['controller' => 'users', 'action' => 'edit', $u->id]
					);
					
					$update_link = '<a href="'.$update_link.'" 
					title ="Update Account" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-edit menu-icon"></i> Make Changes</div></a>';
					
					$reassign = Router::url(
						['controller' => 'users', 'action' => 'edit', $u->id, "reassign"]
					);
					
					$reassign = '<a href="'.$reassign.'" 
					title ="Change Account Role" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-user menu-icon"></i> Change Role</div></a>';

					$actions = $view_link . $update_link . $reassign;
					
					$act = '      <div class="dropdown">
                          <button class="btn btn-outline-info btn-sm dropdown-toggle" type="button" id="dropdownMenuIconButton6" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="typcn typcn-lock-closed"></i>
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuIconButton6">
                            <h6 class="dropdown-header">Action</h6>
                           '.$actions.'
                          </div>
                        </div>';
						
				   $_data[] = array( 
						
						'name'				=> $u->name,
						'vote_for_count'	=> $u->vote_for_count,
						'action'			=> $act
					);
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}
	
	public function add(){
		
			$position = $this->Positions->newEmptyEntity();
			if ($this->request->is('post')) {
				$this->ajaxLayout();
				$code = 0;
				
				$data = $this->request->getData();				
				$position = $this->Positions->patchEntity($position, $data,  ['validate' => false]);
				
				$error = $this->showError($position);
						
				if(!empty($error)) {
					$this->Log(json_encode($position->getErrors()));
					$msg = '<span class="text-danger">'.$error.'</span>';
				}else{
					$position->created = date("Y-m-d H:i:s");
					
					if ($this->Positions->save($position)) {
						$code = 1; 
						$msg = '<span class="text-success">New data successfully registered</span>';
					}else{
						$error = $this->showError($position);
						$this->Log(json_encode($position->getErrors()));
						$msg = '<span class="text-danger">'.$error.'</span>';
					}
				} 
					
				$resp = ['code' => $code, 'msg' => $msg];
				
				
				$this->response = $this->response->withType('application/json')
				->withStringBody(json_encode($resp));
				
				return $this->response;
			}

			$this->set(compact('position'));
		
    }
	
	
	
	

   
}
