<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Precincts Controller
 *
 * @property \App\Model\Table\PrecinctsTable $Precincts
 * @method \App\Model\Entity\Precinct[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class PrecinctsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $precincts = $this->paginate($this->Precincts);

        $this->set(compact('precincts'));
    }

    /**
     * View method
     *
     * @param string|null $id Precinct id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $precinct = $this->Precincts->get($id, [
            'contain' => ['Ballots'],
        ]);

        $this->set(compact('precinct'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $precinct = $this->Precincts->newEmptyEntity();
        if ($this->request->is('post')) {
            $precinct = $this->Precincts->patchEntity($precinct, $this->request->getData());
            if ($this->Precincts->save($precinct)) {
                $this->Flash->success(__('The precinct has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The precinct could not be saved. Please, try again.'));
        }
        $this->set(compact('precinct'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Precinct id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $precinct = $this->Precincts->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $precinct = $this->Precincts->patchEntity($precinct, $this->request->getData());
            if ($this->Precincts->save($precinct)) {
                $this->Flash->success(__('The precinct has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The precinct could not be saved. Please, try again.'));
        }
        $this->set(compact('precinct'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Precinct id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $precinct = $this->Precincts->get($id);
        if ($this->Precincts->delete($precinct)) {
            $this->Flash->success(__('The precinct has been deleted.'));
        } else {
            $this->Flash->error(__('The precinct could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
