<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Trialbalancebeginnings Controller
 *
 * @property \App\Model\Table\TrialbalancebeginningsTable $Trialbalancebeginnings
 * @method \App\Model\Entity\Trialbalancebeginning[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TrialbalancebeginningsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $trialbalancebeginnings = $this->paginate($this->Trialbalancebeginnings);

        $this->set(compact('trialbalancebeginnings'));
    }

    /**
     * View method
     *
     * @param string|null $id Trialbalancebeginning id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $trialbalancebeginning = $this->Trialbalancebeginnings->get($id, [
            'contain' => [],
        ]);

        $this->set(compact('trialbalancebeginning'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $trialbalancebeginning = $this->Trialbalancebeginnings->newEmptyEntity();
        if ($this->request->is('post')) {
            $trialbalancebeginning = $this->Trialbalancebeginnings->patchEntity($trialbalancebeginning, $this->request->getData());
            if ($this->Trialbalancebeginnings->save($trialbalancebeginning)) {
                $this->Flash->success(__('The trialbalancebeginning has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The trialbalancebeginning could not be saved. Please, try again.'));
        }
        $this->set(compact('trialbalancebeginning'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Trialbalancebeginning id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $trialbalancebeginning = $this->Trialbalancebeginnings->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $trialbalancebeginning = $this->Trialbalancebeginnings->patchEntity($trialbalancebeginning, $this->request->getData());
            if ($this->Trialbalancebeginnings->save($trialbalancebeginning)) {
                $this->Flash->success(__('The trialbalancebeginning has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The trialbalancebeginning could not be saved. Please, try again.'));
        }
        $this->set(compact('trialbalancebeginning'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Trialbalancebeginning id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $trialbalancebeginning = $this->Trialbalancebeginnings->get($id);
        if ($this->Trialbalancebeginnings->delete($trialbalancebeginning)) {
            $this->Flash->success(__('The trialbalancebeginning has been deleted.'));
        } else {
            $this->Flash->error(__('The trialbalancebeginning could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
