<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;


use Cake\Datasource\ConnectionManager;
use Cake\Routing\Router;
use Cake\View\Helper\HtmlHelper;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use Cake\Event\EventInterface;

use Cake\Utility\Inflector;

use Cake\Http\Response;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\PngWriter;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UsersController extends AppController
{
		
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
	// in src/Controller/UsersController.php
	
	public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
		
		//$this->Users->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
		
		//$this->set('title', 'Users Masterlist ' .date('Y-m-d'));
		//$this->Authentication->allowUnauthenticated(['login', 'register', 'unauthorized']);
	}
	
	public function dashboard(){
		$user	= $this->getCurrentUser();
		$id 	= $user['id'];
		
		  $user = $this->Users->get($id, [
            'contain' => ['Members'],
        ]);
		
		$this->set(compact('user'));
		
		$cbuTable = \Cake\ORM\TableRegistry::getTableLocator()->get('Membercapitalbuildups');
		$cbu = $cbuTable->getTableRecords($user->member->id);
		
		$loanTable = \Cake\ORM\TableRegistry::getTableLocator()->get('Loanmasters');
		$loan = $loanTable->getActiveLoanByMemberId($user->member->id);
		
		$interest = 0;
		$paidCount = 0;
		if(!empty($loan)){
			$interest = $loanTable->calculateInterest($loan->ApprovedLoanAmount, $loan->MonthsToPay);
			$interest = $loan->ApprovedLoanAmount + $interest;
			
			$detailTable = \Cake\ORM\TableRegistry::getTableLocator()->get('Loandetails');
			$paidCount = $detailTable->countPaidLoandetails($loan->id);
		
		}
		
		
		
		
		$this->set(compact('cbu', 'loan', 'interest', 'paidCount'));
		
		
	}
	
	public function generateQrCode($id=null)
    {
        // Data to be encoded in the QR Code
		
		$user = $this->Users->get($id, ['contain' => []]);
		
		$data = [
			'refid'		=> $user->refid,
			'code' 		=> $user->username,
			'id' 		=> $user->contact_no,
			'pw'		=> $user->password			
		];
		
		$data = base64_encode(json_encode($data));		 
		$data = $this->qrweburl() .$data;
		
		$this->log("URL " . $user->otp." " .$data);
        // Create a QR code object
        $qrCode = QrCode::create($data)
                        ->setSize(500)
                        ->setMargin(10);

        // Create a writer instance
        $writer = new PngWriter();

        // Generate the QR code image
        $result = $writer->write($qrCode);

        // Get QR code image data as string
        $qrCodeString = $result->getString();

        // Create a response with the QR code PNG image
        $response = $this->response->withType('image/png')
                                   ->withStringBody($qrCodeString);

        // Disable CakePHP's default layout rendering
        $this->viewBuilder()->disableAutoLayout();

        return $response;
    }
	
	
	
}
