<?php
declare(strict_types=1);

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller\Admin;
use App\Controller\AppController;
use Cake\Filesystem\Folder;
use Cake\Filesystem\File;

/**
 * Static content controller
 *
 * This controller will render views from templates/Pages/
 *
 * @link https://book.cakephp.org/4/en/controllers/pages-controller.html
 */
class PagesController extends AppController
{
	
	public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
		
		//$this->Users->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
		
		//$this->set('title', 'Users Masterlist ' .date('Y-m-d'));
		//$this->Authentication->allowUnauthenticated(['login', 'register', 'unauthorized']);
	}
	
	public function login(){
		$this->viewBuilder()->setLayout('login');
		$this->Authorization->skipAuthorization();
		$user = $this->Users->newEmptyEntity();
		$this->set('user', $user);
			
		
		if($this->request->is('post')){
			
			//$data = $this->request->getData();
			//$this->log(json_encode($data));
			$result = $this->Authentication->getResult();
			$status = 0;
			$role = 0;
			$target = 0;
			
			if ($result->isValid()) {
				// If the user is logged in send them away.
				//
				$user = $result->getData();
				//check member status
				if($user->status=="ACTIVE"){
					$this->updateLogin("logout", $user->id);
					
					//$this->generateNewOTP($user->id);
					$role = $user->role_id;
					$status = 1;
					$msg = "Account successfully authenticated, please click Proceed to continue";
					//if($user->role_id == 1) { //administrator
						//$this->updateLogin("login", $user->id);
						//$target = $this->Authentication->getLoginRedirect() ?? '/admin/elections/dashboard';
						
						//$target = $this->Authentication->getLoginRedirect() ?? '/users/validateotpadmin';
						
					//}else{				
						//$target = $this->Authentication->getLoginRedirect() ?? '/member/users/my-profile';
						//$target = $this->Authentication->getLoginRedirect() ?? '/users/validateotp';
					//}
					$target = $this->Authentication->getLoginRedirect() ?? '/admin/settings/system-statistics';
					
				}else{
					$msg = "Your account needs to be activated. Please check your email for the activation link";
					//$this->Flash->error('Your account is temporary deactivated');
					//$target = $this->Authentication->getLoginRedirect() ?? '/users/logout';
				}
					//return $this->redirect($target);
			}else{
				$msg ="Login failed. You have provided an invalid credentials.";
			}
			
			if($this->request->is('ajax')){
				$resp = [
					'target' => $target,
					'role' => $role,
					'status' => $status,
					'message' => $msg
				];
				
				echo json_encode($resp);
				exit();
			}else{
				return $this->redirect($target);
			}
		} 
		
		
	}
	

}
