<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Ballot Entity
 *
 * @property int $id
 * @property string $qr_code
 * @property int $precinct_id
 * @property int $election_id
 * @property bool|null $is_validated
 *
 * @property \App\Model\Entity\Precinct $precinct
 * @property \App\Model\Entity\Election $election
 */
class Ballot extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'qr_code' => true,
        'precinct_id' => true,
        'election_id' => true,
        'is_validated' => true,
        'precinct' => true,
        'election' => true,
    ];
}
