<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Benefit Entity
 *
 * @property int $id
 * @property int $member_id
 * @property string $beneficiary
 * @property \Cake\I18n\FrozenDate $dob
 * @property string|null $share
 * @property string $mobile
 * @property string $address
 * @property string|null $scanned_docs
 *
 * @property \App\Model\Entity\Member $member
 */
class Benefit extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'member_id' => true,
        'beneficiary' => true,
        'dob' => true,
        'share' => true,
        'mobile' => true,
        'address' => true,
        'scanned_docs' => true,
        'member' => true,
        'relation' => true,
        'irrevocable' => true,
        'plantype' => true,
    ];
}
