<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Candidate Entity
 *
 * @property int $id
 * @property string $name
 * @property string|null $party_affiliation
 * @property int $position_id
 *
 * @property \App\Model\Entity\Position $position
 * @property \App\Model\Entity\Electioncandidate[] $electioncandidates
 */
class Candidate extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'name' => true,
        'party_affiliation' => true,
        'position_id' => true,
        'position' => true,
        'electioncandidates' => true,
    ];
}
