<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Cart Entity
 *
 * @property int $id
 * @property int $user_id
 * @property \Cake\I18n\FrozenTime|null $created
 * @property string|null $amount
 * @property string|null $vat_amount
 * @property string|null $total
 * @property string|null $status
 * @property string|null $payment_type
 *
 * @property \App\Model\Entity\User $user
 * @property \App\Model\Entity\Cartitem[] $cartitems
 * @property \App\Model\Entity\Transaction[] $transactions
 */
class Cart extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'user_id' => true,
        'created' => true,
        'amount' => true,
        'vat_amount' => true,
        'total' => true,
        'status' => true,
        'payment_type' => true,
        'user' => true,
        'cartitems' => true,
        'transactions' => true,
    ];
}
