<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Cartitem Entity
 *
 * @property int $id
 * @property int $cart_id
 * @property int $product_id
 * @property string|null $selling_price
 * @property string|null $discount
 * @property string $qty
 * @property string|null $total_amount
 *
 * @property \App\Model\Entity\Cart $cart
 * @property \App\Model\Entity\Product $product
 */
class Cartitem extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'cart_id' => true,
        'product_id' => true,
        'selling_price' => true,
        'discount' => true,
        'qty' => true,
        'total_amount' => true,
        'cart' => true,
        'product' => true,
    ];
}
