<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Chartofaccount Entity
 *
 * @property int $int
 * @property string|null $AccountCode
 * @property string|null $AccountTitle
 * @property string|null $EntryDate
 * @property string|null $UpdateDateTime
 */
class Chartofaccount extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'AccountCode' => true,
        'AccountTitle' => true,
        'EntryDate' => true,
        'UpdateDateTime' => true,
        'note' => true,
        'status' => true,
        'transactiondetails' => true,
    ];
	
	protected $_virtual = ['code_and_title'];

    protected function _getCodeAndTitle()
    {
        return $this->AccountCode . ' - ' . $this->AccountTitle;
    }
	
}
