<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Division Entity
 *
 * @property int $id
 * @property int $region_id
 * @property string $name
 * @property string|null $remarks
 * @property string|null $mas_from
 * @property string|null $mas_to
 * @property string|null $glpp_from
 * @property string|null $glpp_to
 *
 * @property \App\Model\Entity\Region $region
 * @property \App\Model\Entity\School[] $schools
 */
class Division extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'region_id' => true,
        'name' => true,
        'remarks' => true,
        'mas_from' => true,
        'mas_to' => true,
        'glpp_from' => true,
        'glpp_to' => true,
        'region' => true,
        'schools' => true,
    ];
}
