<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Document Entity
 *
 * @property int $id
 * @property int $member_id
 * @property string $code
 * @property string $description
 * @property string $file
 *
 * @property \App\Model\Entity\Member $member
 */
class Document extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'member_id' => true,
        'code' => true,
        'description' => true,
        'file' => true,
        'added' => true,
        'member' => true,
        'uploaded_by' => true,
        'ext' => true
    ];
}
