<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Election Entity
 *
 * @property int $id
 * @property string $name
 * @property string|null $type
 * @property \Cake\I18n\FrozenDate|null $date
 *
 * @property \App\Model\Entity\Ballot[] $ballots
 * @property \App\Model\Entity\Electioncandidate[] $electioncandidates
 */
class Election extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'name' => true,
        'type' => true,
        'election_date' => true,
        'created' => true,
        'note' => true,
        'ballots' => true,
        'electioncandidates' => true,
    ];
}
