<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Loanmaster Entity
 *
 * @property int $id
 * @property int|null $MemberId
 * @property string|null $LoanType
 * @property string|null $ApprovedLoanAmount
 * @property int|null $MonthsToPay
 * @property string|null $ServiceFee
 * @property string|null $PercentInterest
 * @property string|null $Penalty
 * @property string|null $NetAmountOfLoan
 * @property string|null $Insurance
 * @property string|null $PercentCapitalBuildUp
 * @property string|null $PrePayments
 * @property string|null $OtherDeductions
 * @property string|null $MonthlyAmortization
 * @property string|null $AmortizationStart
 * @property string|null $AmortizationEnd
 * @property string|null $OtherPayments
 * @property string|null $LessRebates
 * @property string|null $ApprovedDate
 * @property string|null $Status
 * @property string|null $EntryDate
 * @property string|null $UpdateDateTime
 * @property string|null $OtherDeductionsPrePayment
 * @property string|null $OtherDeductionsCanteen
 * @property string|null $Remarks
 */
class Loanmaster extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'MemberId' => true,
        'LoanType' => true,
        'ApprovedLoanAmount' => true,
        'MonthsToPay' => true,
        'ServiceFee' => true,
        'PercentInterest' => true,
        'Penalty' => true,
        'NetAmountOfLoan' => true,
        'Insurance' => true,
        'PercentCapitalBuildUp' => true,
        'PrePayments' => true,
        'OtherDeductions' => true,
        'MonthlyAmortization' => true,
        'AmortizationStart' => true,
        'AmortizationEnd' => true,
        'OtherPayments' => true,
        'LessRebates' => true,
        'ApprovedDate' => true,
        'Status' => true,
        'EntryDate' => true,
        'UpdateDateTime' => true,
        'OtherDeductionsPrePayment' => true,
        'OtherDeductionsCanteen' => true,
        'Remarks' => true,
        'member' => true,
        'transactionmasters' => true,
        'servicefee_amount' => true,
        'interest_amount' => true,
        'cbu_amount' => true,
        'loan_payable' => true,
        'total_deduction' => true
    ];
}
