<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Member Entity
 *
 * @property int $id
 * @property int $user_id
 * @property string|null $LastName
 * @property string|null $FirstName
 * @property string|null $MI
 * @property string|null $Address
 * @property string|null $SpouseName
 * @property string|null $DateOfBirth
 * @property string|null $Sex
 * @property string|null $Height
 * @property string|null $Weight
 * @property string|null $CivilStatus
 * @property int|null $Salary
 * @property string|null $Status
 * @property string|null $Education
 * @property string|null $Position
 * @property string|null $Office
 * @property string|null $DateApplied
 * @property string|null $DatePaid
 * @property string|null $EntryDate
 * @property string|null $UpdateDateTime
 *
 * @property \App\Model\Entity\Document[] $documents
 * @property \App\Model\Entity\Benefit[] $benefits
 */
class Member extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'user_id' => true,
        'LastName' => true,
        'FirstName' => true,
        'MI' => true,
        'Address' => true,
        'SpouseName' => true,
        'DateOfBirth' => true,
        'Sex' => true,
        'Height' => true,
        'Weight' => true,
        'CivilStatus' => true,
        'Salary' => true,
        'Status' => true,
        'Education' => true,
        'Position' => true,
        'Office' => true,
        'DateApplied' => true,
        'DatePaid' => true,
        'EntryDate' => true,
        'UpdateDateTime' => true,
        'note' => true,
        'documents' => true,
        'benefits' => true,
        'user' => true,
		'membercapitalbuildups',
		'loanmasters',
		'monthlydeductions',
		'memberschildrens'
    ];
}
