<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Officerposition Entity
 *
 * @property int $id
 * @property int $election_id
 * @property string $name
 * @property int $max_selecton
 * @property int|null $min_selection
 * @property string $status
 * @property int $candidate_allowed
 * @property string $candidate_count
 * @property string|null $votecasting_count
 *
 * @property \App\Model\Entity\Election $election
 * @property \App\Model\Entity\Candidate[] $candidates
 * @property \App\Model\Entity\Votecasting[] $votecastings
 */
class Officerposition extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'election_id' => true,
        'name' => true,
        'max_selection' => true,
        'min_selection' => true,
        'status' => true,
        'candidate_allowed' => true,
        'candidate_count' => true,
        //'votecasting_count' => true,
        'election' => true,
        'candidates' => true,
        'total_winner' => true

    ];
}
