<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Product Entity
 *
 * @property int $id
 * @property int $category_id
 * @property string $name
 * @property \Cake\I18n\FrozenTime $created
 * @property int $created_by
 *
 * @property \App\Model\Entity\Stock[] $stocks
 */
class Product extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'category_id' => true,
        'refid' => true,
        'name' => true,
        'created' => true,
        'created_by' => true,
        'stock' => true,
        'category' => true,
        'notes' => true,
        'image' => true,
        'refunds' => true,
    ];
}
