<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Refund Entity
 *
 * @property int $id
 * @property int $product_id
 * @property string $invoice_no
 * @property int $created_by
 * @property \Cake\I18n\FrozenTime $created
 * @property string $price
 * @property int $qty
 * @property string $total
 * @property string|null $reason
 *
 * @property \App\Model\Entity\Product $product
 */
class Refund extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'product_id' => true,
        'invoice_no' => true,
        'created_by' => true,
        'created' => true,
        'price' => true,
        'qty' => true,
        'total' => true,
        'reason' => true,
        'product' => true,
        'status' => true,
        'sale' => true,
    ];
}
