<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Sale Entity
 *
 * @property int $id
 * @property int $user_id
 * @property \Cake\I18n\FrozenTime|null $created
 * @property string|null $amount
 * @property string|null $disc_percent
 * @property string|null $disc_amount
 * @property string|null $vat_percent
 * @property string|null $vat_amount
 * @property string|null $total
 * @property string|null $status
 * @property string|null $payment_type
 * @property string|null $paid_amount
 * @property string|null $changed
 *
 * @property \App\Model\Entity\User $user
 * @property \App\Model\Entity\Transaction[] $transactions
 */
class Sale extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
	 
	 protected function _setCreated(){
        return date('Y-m-d H:i:s');
    }
	
    protected $_accessible = [
        'user_id' => true,
        'created' => true,
        'amount' => true,
        'disc_percent' => true,
        'disc_amount' => true,
        'vat_percent' => true,
        'vat_amount' => true,
        'total' => true,
        'status' => true,
        'payment_type' => true,
        'paid_amount' => true,
        'changed' => true,
        'user' => true,
        'transactions' => true,
        'refunds' => true,
    ];
}
