<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Station Entity
 *
 * @property int $id
 * @property int $region_id
 * @property int $division_id
 * @property string $name
 * @property string|null $remarks
 *
 * @property \App\Model\Entity\Region $region
 * @property \App\Model\Entity\Division $division
 */
class Station extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'region_id' => true,
        'division_id' => true,
        'name' => true,
        'remarks' => true,
        'region' => true,
        'division' => true,
    ];
}
