<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Stock Entity
 *
 * @property int $id
 * @property int $product_id
 * @property \Cake\I18n\FrozenTime $price_date
 * @property string|null $purchase_price
 * @property string|null $selling_price
 * @property string|null $total_count
 * @property string|null $available_count
 * @property string|null $sold_count
 * @property string|null $notes
 * @property \Cake\I18n\FrozenTime|null $created
 * @property int $created_by
 *
 * @property \App\Model\Entity\Product $product
 * @property \App\Model\Entity\Transaction[] $transactions
 */
class Stock extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'product_id' => true,
        'price_date' => true,
        'purchase_price' => true,
        'selling_price' => true,
        'total_count' => true,
        'available_count' => true,
        'sold_count' => true,
        'sold_amount' => true,
        'notes' => true,
        'created' => true,
        'created_by' => true,
        'product' => true,
        'transactions' => true,
        'user' => true,
        'refundqty' => true,
    ];
}
