<?php
declare(strict_types=1);


namespace App\Model\Entity;

/*authorization purpose*/
use Authorization\AuthorizationServiceInterface;
//use Authorization\IdentityInterface;
use Authorization\Policy\ResultInterface; 


use Cake\ORM\Entity;
use Authentication\PasswordHasher\DefaultPasswordHasher;

use Authorization\IdentityInterface as AuthorizationIdentity;
use Authentication\IdentityInterface as AuthenticationIdentity;

use Cake\Datasource\ConnectionManager;
use Cake\ORM\Query;
use Cake\ORM\Table;


class User extends Entity implements AuthorizationIdentity, AuthenticationIdentity {
	
	
   public function checkUam($controller=null, $action=null){
		$con 	 	= ConnectionManager::get('default');
		//$controller = 'articles'; //$this->request->params['controller'];
		//$action		= $this->request->params['action'];
		//$action  	= $this->request->getParam("action"); // $this->request->getParam("action");
		$group 		= $this->getGroup();
		
		
		$uam = $con
			->execute("SELECT id FROM uams 
				WHERE controller = :controller 
				AND FIND_IN_SET(:action, actions) 
				AND role_id = :group 
				LIMIT 1", 
				[
					'controller' => $controller, 
					'action' => $action, 
					'group' => $group
				]
			)
			->fetchAll('assoc');
		
		
		if(!empty($uam)){
			return true;
		}else{
			return false;
		}
		
	}
	
    public function can($action, $resource): bool{
        return $this->authorization->can($this, $action, $resource);
    }
   
     public function canResult($action, $resource): ResultInterface{
        return $this->authorization->canResult($this, $action, $resource);
    }
 
    public function applyScope($action, $resource){
        return $this->authorization->applyScope($this, $action, $resource);
    }

    public function getOriginalData(){
        return $this;
    }
	
   
    public function setAuthorization(AuthorizationServiceInterface $service){
        $this->authorization = $service;
        return $this;
    }
	
    public function getIdentifier(){
        return $this->id;
    } 
	
	public function getGroup(){
        return $this->role_id;
    } 
	
	protected function _setPassword(string $password){
        $hasher = new DefaultPasswordHasher();
        return $hasher->hash($password);
    }
	
	protected function _setRefid(string $refid){
		//$time = new Datetime("now");
		//$time = $time->format('U');
		
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < 6; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		
        $refid = microtime(true) . $str;
		return $refid;
	}
	
	protected function _setCreated(){
        return date('Y-m-d H:i:s');
    }
	
	 
    protected $_accessible = [
        'refid' 				=> true,
        'role_id' 			=> true,
        'username' 		=> true,
        'password' 		=> true, 
        'contact_no'		=> true,
        'name' 				=> true,
        'userlogins' 		=> true,
        'created' 			=> true,
        'role' 					=> true,      
        'last_login' 		=> true,      
        'last_logout' 		=> true,      
        'login_status' 	=> true,      
        'otp' 					=> true,      
        'otp_status' 		=> true,      
        'otp_generated' 	=> true,
        'avatar' 				=> true,
        'dob' 					=> true,
        'note' 				=> true,
        'sex' 					=> true,
        'sales' 				=> true,
        'stocks' 			=> true,
        'rate' 				=> true,
        'rate_by' 			=> true,
        'scheds' 			=> true,
        'time_in' 			=> true,
        'time_out' 			=> true,
        'ip_address' 		=> true,
        'skey' 				=> true,
        'member' 			=> true,
    ];

    /**
     * Fields that are excluded from JSON versions of the entity.
     *
     * @var array<string>
     */
    protected $_hidden = [
        'password',
    ];
}
