<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Accountmaps Model
 *
 * @method \App\Model\Entity\Accountmap newEmptyEntity()
 * @method \App\Model\Entity\Accountmap newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Accountmap[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Accountmap get($primaryKey, $options = [])
 * @method \App\Model\Entity\Accountmap findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Accountmap patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Accountmap[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Accountmap|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Accountmap saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Accountmap[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Accountmap[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Accountmap[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Accountmap[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class AccountmapsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('accountmaps');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('OldAccountCode')
            ->allowEmptyString('OldAccountCode');

        $validator
            ->scalar('NewAccountCode')
            ->allowEmptyString('NewAccountCode');

        return $validator;
    }
}
