<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Ballots Model
 *
 * @property \App\Model\Table\PrecinctsTable&\Cake\ORM\Association\BelongsTo $Precincts
 * @property \App\Model\Table\ElectionsTable&\Cake\ORM\Association\BelongsTo $Elections
 *
 * @method \App\Model\Entity\Ballot newEmptyEntity()
 * @method \App\Model\Entity\Ballot newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Ballot[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Ballot get($primaryKey, $options = [])
 * @method \App\Model\Entity\Ballot findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Ballot patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Ballot[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Ballot|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Ballot saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Ballot[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Ballot[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Ballot[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Ballot[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class BallotsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('ballots');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Precincts', [
            'foreignKey' => 'precinct_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Elections', [
            'foreignKey' => 'election_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('qr_code')
            ->maxLength('qr_code', 255)
            ->requirePresence('qr_code', 'create')
            ->notEmptyString('qr_code');

        $validator
            ->integer('precinct_id')
            ->notEmptyString('precinct_id');

        $validator
            ->integer('election_id')
            ->notEmptyString('election_id');

        $validator
            ->boolean('is_validated')
            ->allowEmptyString('is_validated');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn('precinct_id', 'Precincts'), ['errorField' => 'precinct_id']);
        $rules->add($rules->existsIn('election_id', 'Elections'), ['errorField' => 'election_id']);

        return $rules;
    }
}
