<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Barangays Model
 *
 * @method \App\Model\Entity\Barangay newEmptyEntity()
 * @method \App\Model\Entity\Barangay newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Barangay[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Barangay get($primaryKey, $options = [])
 * @method \App\Model\Entity\Barangay findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Barangay patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Barangay[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Barangay|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Barangay saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Barangay[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Barangay[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Barangay[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Barangay[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class BarangaysTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('barangays');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('brgyCode')
            ->maxLength('brgyCode', 255)
            ->allowEmptyString('brgyCode');

        $validator
            ->scalar('brgyDesc')
            ->allowEmptyString('brgyDesc');

        $validator
            ->scalar('regCode')
            ->maxLength('regCode', 255)
            ->allowEmptyString('regCode');

        $validator
            ->scalar('provCode')
            ->maxLength('provCode', 255)
            ->allowEmptyString('provCode');

        $validator
            ->scalar('citymunCode')
            ->maxLength('citymunCode', 255)
            ->allowEmptyString('citymunCode');

        return $validator;
    }
}
