<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Benefits Model
 *
 * @property \App\Model\Table\MembersTable&\Cake\ORM\Association\BelongsTo $Members
 *
 * @method \App\Model\Entity\Benefit newEmptyEntity()
 * @method \App\Model\Entity\Benefit newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Benefit[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Benefit get($primaryKey, $options = [])
 * @method \App\Model\Entity\Benefit findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Benefit patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Benefit[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Benefit|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Benefit saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Benefit[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Benefit[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Benefit[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Benefit[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class BenefitsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('benefits');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Members', [
            'foreignKey' => 'member_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('member_id')
            ->notEmptyString('member_id');

        $validator
            ->scalar('fname')
            ->maxLength('fname', 35)
            ->requirePresence('fname', 'create')
            ->notEmptyString('fname', 'First name is required');
		
		$validator
            ->scalar('lname')
            ->maxLength('lname', 35)
            ->requirePresence('lname', 'create')
            ->notEmptyString('lname', 'Family name is required');

        $validator
            ->date('dob')
            ->requirePresence('dob', 'create')
            ->notEmptyDate('dob', 'Date of birth is required');

        $validator
            ->decimal('share')
            ->allowEmptyString('share', 'Share is required');

        // $validator
            // ->scalar('mobile')
            // ->maxLength('mobile', 11)
            // ->requirePresence('mobile', 'create')
            // ->notEmptyString('mobile');

        // $validator
            // ->scalar('address')
            // ->requirePresence('address', 'create')
            // ->notEmptyString('address');

        $validator
            ->scalar('scanned_docs')
            ->allowEmptyString('scanned_docs');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn('member_id', 'Members'), ['errorField' => 'member_id']);

        return $rules;
    }
}
