<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Cbuschedules Model
 *
 * @property \App\Model\Table\MembersTable&\Cake\ORM\Association\BelongsTo $Members
 *
 * @method \App\Model\Entity\Cbuschedule newEmptyEntity()
 * @method \App\Model\Entity\Cbuschedule newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Cbuschedule[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Cbuschedule get($primaryKey, $options = [])
 * @method \App\Model\Entity\Cbuschedule findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Cbuschedule patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Cbuschedule[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Cbuschedule|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Cbuschedule saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Cbuschedule[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Cbuschedule[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Cbuschedule[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Cbuschedule[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class CbuschedulesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('cbuschedules');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Members', [
            'foreignKey' => 'member_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('member_id')
            ->allowEmptyString('member_id');

        $validator
            ->scalar('Pay5')
            ->maxLength('Pay5', 12)
            ->allowEmptyString('Pay5');

        $validator
            ->scalar('Pay20')
            ->maxLength('Pay20', 12)
            ->allowEmptyString('Pay20');

        $validator
            ->scalar('Total')
            ->maxLength('Total', 12)
            ->allowEmptyString('Total');

        $validator
            ->scalar('CreatedDate')
            ->maxLength('CreatedDate', 12)
            ->allowEmptyString('CreatedDate');

        $validator
            ->scalar('UpdatedDate')
            ->maxLength('UpdatedDate', 12)
            ->allowEmptyString('UpdatedDate');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn('member_id', 'Members'), ['errorField' => 'member_id']);

        return $rules;
    }
}
