<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Chartaccountnews Model
 *
 * @method \App\Model\Entity\Chartaccountnews newEmptyEntity()
 * @method \App\Model\Entity\Chartaccountnews newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Chartaccountnews[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Chartaccountnews get($primaryKey, $options = [])
 * @method \App\Model\Entity\Chartaccountnews findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Chartaccountnews patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Chartaccountnews[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Chartaccountnews|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chartaccountnews saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chartaccountnews[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Chartaccountnews[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Chartaccountnews[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Chartaccountnews[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class ChartaccountnewsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('chartaccountnews');
        $this->setDisplayField('int');
        $this->setPrimaryKey('int');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('AccountCode')
            ->maxLength('AccountCode', 12)
            ->allowEmptyString('AccountCode');

        $validator
            ->scalar('AccountName')
            ->maxLength('AccountName', 12)
            ->allowEmptyString('AccountName');

        $validator
            ->scalar('AccountType')
            ->maxLength('AccountType', 12)
            ->allowEmptyString('AccountType');

        $validator
            ->scalar('ParentCode')
            ->maxLength('ParentCode', 12)
            ->allowEmptyString('ParentCode');

        $validator
            ->scalar('SummaryAccount')
            ->maxLength('SummaryAccount', 12)
            ->allowEmptyString('SummaryAccount');

        $validator
            ->scalar('GLDebit')
            ->maxLength('GLDebit', 12)
            ->allowEmptyString('GLDebit');

        $validator
            ->scalar('GLCredit')
            ->maxLength('GLCredit', 12)
            ->allowEmptyString('GLCredit');

        return $validator;
    }
}
