<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Electioncandidates Model
 *
 * @property \App\Model\Table\ElectionsTable&\Cake\ORM\Association\BelongsTo $Elections
 * @property \App\Model\Table\CandidatesTable&\Cake\ORM\Association\BelongsTo $Candidates
 *
 * @method \App\Model\Entity\Electioncandidate newEmptyEntity()
 * @method \App\Model\Entity\Electioncandidate newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Electioncandidate[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Electioncandidate get($primaryKey, $options = [])
 * @method \App\Model\Entity\Electioncandidate findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Electioncandidate patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Electioncandidate[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Electioncandidate|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Electioncandidate saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Electioncandidate[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Electioncandidate[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Electioncandidate[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Electioncandidate[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class ElectioncandidatesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('electioncandidates');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Elections', [
            'foreignKey' => 'election_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Candidates', [
            'foreignKey' => 'candidate_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('election_id')
            ->notEmptyString('election_id');

        $validator
            ->integer('candidate_id')
            ->notEmptyString('candidate_id');

        $validator
            ->integer('votes_received')
            ->allowEmptyString('votes_received');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn('election_id', 'Elections'), ['errorField' => 'election_id']);
        $rules->add($rules->existsIn('candidate_id', 'Candidates'), ['errorField' => 'candidate_id']);

        return $rules;
    }
}
