<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Elections Model
 *
 * @property \App\Model\Table\BallotsTable&\Cake\ORM\Association\HasMany $Ballots
 * @property \App\Model\Table\ElectioncandidatesTable&\Cake\ORM\Association\HasMany $Electioncandidates
 *
 * @method \App\Model\Entity\Election newEmptyEntity()
 * @method \App\Model\Entity\Election newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Election[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Election get($primaryKey, $options = [])
 * @method \App\Model\Entity\Election findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Election patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Election[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Election|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Election saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Election[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Election[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Election[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Election[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class ElectionsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('elections');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->hasMany('Ballots', [
            'foreignKey' => 'election_id',
        ]);
        $this->hasMany('Electioncandidates', [
            'foreignKey' => 'election_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('name')
            ->maxLength('name', 50)
            ->requirePresence('name', 'create')
            ->notEmptyString('name');

        $validator
            ->scalar('type')
            ->maxLength('type', 35)
            ->allowEmptyString('type');

        $validator
            ->date('election_date')
            ->allowEmptyDate('date');

        return $validator;
    }
}
