<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Generalledgersummaries Model
 *
 * @method \App\Model\Entity\Generalledgersummary newEmptyEntity()
 * @method \App\Model\Entity\Generalledgersummary newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Generalledgersummary[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Generalledgersummary get($primaryKey, $options = [])
 * @method \App\Model\Entity\Generalledgersummary findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Generalledgersummary patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Generalledgersummary[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Generalledgersummary|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Generalledgersummary saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Generalledgersummary[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Generalledgersummary[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Generalledgersummary[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Generalledgersummary[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class GeneralledgersummariesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('generalledgersummaries');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('Period')
            ->maxLength('Period', 12)
            ->allowEmptyString('Period');

        $validator
            ->scalar('AccountCode')
            ->maxLength('AccountCode', 12)
            ->allowEmptyString('AccountCode');

        $validator
            ->scalar('Debit')
            ->maxLength('Debit', 12)
            ->allowEmptyString('Debit');

        $validator
            ->scalar('Credit')
            ->maxLength('Credit', 12)
            ->allowEmptyString('Credit');

        $validator
            ->scalar('YearToDateDebit')
            ->maxLength('YearToDateDebit', 12)
            ->allowEmptyString('YearToDateDebit');

        $validator
            ->scalar('YearToDateCredit')
            ->maxLength('YearToDateCredit', 12)
            ->allowEmptyString('YearToDateCredit');

        return $validator;
    }
}
