<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Loandetails Model
 *
 * @method \App\Model\Entity\Loandetail newEmptyEntity()
 * @method \App\Model\Entity\Loandetail newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Loandetail[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Loandetail get($primaryKey, $options = [])
 * @method \App\Model\Entity\Loandetail findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Loandetail patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Loandetail[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Loandetail|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Loandetail saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Loandetail[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Loandetail[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Loandetail[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Loandetail[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class LoandetailsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('loandetails');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
		
		$this->belongsTo('Loanmasters', [
            'foreignKey' => 'LoanMasterId',
            'joinType' => 'INNER',
        ]);
		
		
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
       /*  $validator
            ->integer('LoanMasterId')
            ->allowEmptyString('LoanMasterId'); */

       /*  $validator
            ->scalar('AmortizationDate')
            ->maxLength('AmortizationDate', 19)
            ->allowEmptyString('AmortizationDate');

        $validator
            ->decimal('MonthlyAmortization')
            ->allowEmptyString('MonthlyAmortization');

        $validator
            ->decimal('Principal')
            ->allowEmptyString('Principal');

        $validator
            ->decimal('Interest')
            ->allowEmptyString('Interest');

        $validator
            ->scalar('Status')
            ->maxLength('Status', 6)
            ->allowEmptyString('Status');

        $validator
            ->scalar('Remarks')
            ->maxLength('Remarks', 66)
            ->allowEmptyString('Remarks');

        $validator
            ->scalar('EntryDate')
            ->maxLength('EntryDate', 19)
            ->allowEmptyString('EntryDate');

        $validator
            ->scalar('UpdateDateTime')
            ->maxLength('UpdateDateTime', 19)
            ->allowEmptyString('UpdateDateTime');

        $validator
            ->scalar('PayDate')
            ->maxLength('PayDate', 19)
            ->allowEmptyString('PayDate');
		*/
        return $validator;
    }
	
	public function countPaidLoandetails($loanId)
    {
        $count = $this->find()
                      ->where(['LoanMasterId' => $loanId, 'Status' => 'PAID'])
                      ->count();

        return $count;
    }
	
}
