<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Officerpositions Model
 *
 * @property \App\Model\Table\ElectionsTable&\Cake\ORM\Association\BelongsTo $Elections
 * @property \App\Model\Table\CandidatesTable&\Cake\ORM\Association\HasMany $Candidates
 * @property \App\Model\Table\VotecastingsTable&\Cake\ORM\Association\HasMany $Votecastings
 *
 * @method \App\Model\Entity\Officerposition newEmptyEntity()
 * @method \App\Model\Entity\Officerposition newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Officerposition[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Officerposition get($primaryKey, $options = [])
 * @method \App\Model\Entity\Officerposition findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Officerposition patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Officerposition[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Officerposition|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Officerposition saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Officerposition[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Officerposition[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Officerposition[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Officerposition[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class OfficerpositionsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('officerpositions');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->belongsTo('Elections', [
            'foreignKey' => 'election_id',
            'joinType' => 'INNER',
        ]);
        $this->hasMany('Candidates', [
            'foreignKey' => 'officerposition_id',
        ]);
		
        /* $this->hasMany('Votecastings', [
            'foreignKey' => 'officerposition_id',
        ]); */
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->integer('election_id')
            ->notEmptyString('election_id');

        $validator
            ->scalar('name')
            ->maxLength('name', 35)
            ->requirePresence('name', 'create')
            ->notEmptyString('name', 'Position Name is Required');

        $validator
            ->notEmptyString('max_selection', 'Max Selection is Required')
			->add('max_selection', 'comparison', [
				'rule' => function ($value, $context) {
					return intval($value) >= intval($context['data']['min_selection']) ;
				},
				'message' => 'Max Selection cannot be lesser than Min Selection.'
			]);  
		
		$validator
            ->notEmptyString('total_winner', 'No. of Possible Winner is Required')
			->add('total_winner', 'comparison', [
				'rule' => function ($value, $context) {
					return intval($value) <= intval($context['data']['max_selection']) ;
				},
				'message' => 'Possible winner cannot be more than Max Selection.'
			]);
			
        $validator
            ->allowEmptyString('min_selection', 'Min Selection is Required')
			->add('min_selection', 'comparison', [
				'rule' => function ($value, $context) {
					return intval($value) <= intval($context['data']['max_selection']) ;
				},
				'message' => 'Min Selection cannot be larger than Max Selection.'
			]);
			
			
        $validator
            ->scalar('status')
            ->maxLength('status', 10)
            ->notEmptyString('status', 'Status is Required');

        $validator
            ->notEmptyString('candidate_allowed', 'Max Registration Allowed is Required');
/* 
        $validator
            ->scalar('candidate_count')
            ->maxLength('candidate_count', 3)
            ->requirePresence('candidate_count', 'create')
            ->notEmptyString('candidate_count');

        $validator
            ->scalar('votecasting_count')
            ->maxLength('votecasting_count', 6)
            ->allowEmptyString('votecasting_count'); */

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
       $rules->add($rules->isUnique(
			['election_id', 'name'],
			'Officer Position Already exists. Please check the details again.'
		), 
			['errorField' => 'name']
		);

        return $rules;
    }
	
	
		
		
}
