<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Precincts Model
 *
 * @property \App\Model\Table\BallotsTable&\Cake\ORM\Association\HasMany $Ballots
 *
 * @method \App\Model\Entity\Precinct newEmptyEntity()
 * @method \App\Model\Entity\Precinct newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Precinct[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Precinct get($primaryKey, $options = [])
 * @method \App\Model\Entity\Precinct findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Precinct patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Precinct[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Precinct|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Precinct saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Precinct[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Precinct[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Precinct[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Precinct[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class PrecinctsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('precincts');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->hasMany('Ballots', [
            'foreignKey' => 'precinct_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('clustered')
            ->maxLength('clustered', 35)
            ->requirePresence('clustered', 'create')
            ->notEmptyString('clustered');

        $validator
            ->scalar('location')
            ->allowEmptyString('location');

        return $validator;
    }
}
