<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Systemcounters Model
 *
 * @method \App\Model\Entity\Systemcounter newEmptyEntity()
 * @method \App\Model\Entity\Systemcounter newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Systemcounter[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Systemcounter get($primaryKey, $options = [])
 * @method \App\Model\Entity\Systemcounter findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Systemcounter patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Systemcounter[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Systemcounter|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Systemcounter saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Systemcounter[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Systemcounter[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Systemcounter[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Systemcounter[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class SystemcountersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('systemcounters');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('TransactionCode')
            ->maxLength('TransactionCode', 2)
            ->allowEmptyString('TransactionCode');

        $validator
            ->allowEmptyString('TransactionNumber');

        return $validator;
    }
}
