<?php
declare(strict_types=1);

namespace App\Policy;

use App\Model\Entity\Article;
use Authorization\IdentityInterface;
//use Authorization\Policy\Result;
use Authorization\Policy\BeforePolicyInterface;

//for routing and request purpose 
//to get the current action & controller 
use Cake\Http\ServerRequest;
use Cake\Routing\RouterBuilder;
use Cake\Routing\Router;

class ArticlePolicy implements BeforePolicyInterface
//class ArticlePolicy
{
	
	/*construct a new request */
	function __construct() {
        $this->request = Router::getRequest();
    }
	
	public function before($user, $resource, $action){
		//$ctrl 	= $this->request->getParam('controller');
		//$actn 	= $this->request->getParam('action');
		//return debug(Router::getParams());
		
		if($user->getGroup() == 1){ //admin group id
			return true;
		}/* else{
			if($user->checkUam($ctrl, $actn)){
				return true;
			}else{
				return false;
			}
		} */
        // fall through
		
    }
	

	
	public function canAdd(IdentityInterface $user, Article $article)
    {
        // All logged in users can create articles.
        return true;
    }

    public function canEdit(IdentityInterface $user, Article $article)
    {
        // logged in users can edit their own articles.
		$ctrl 	= $this->request->getParam('controller');
		$actn 	= $this->request->getParam('action');
		
		if($user->checkUam($ctrl, $actn)){
			//return true;
			 return $this->isAuthor($user, $article);
		}else{
			return false;
		}
       
    }

	public function canView(IdentityInterface $user, Article $article)
    {
        // logged in users can edit their own articles.
        return $this->isAuthor($user, $article);
    }

    public function canDelete(IdentityInterface $user, Article $article)
    {
        // logged in users can delete their own articles.
        return false; //$this->isAuthor($user, $article);
    }

    protected function isAuthor(IdentityInterface $user, Article $article)
    {
        return $article->user_id === $user->getIdentifier();
    }
	
	
}