<?php
declare(strict_types=1);

namespace App\Policy;

use App\Model\Table\ArticlesTable;
use Authorization\IdentityInterface;

/**
 * Articles policy
 */
class ArticlesTablePolicy
{
	
	public function canIndex($user, $query){
		return true;
    }
	
	public function scopeIndex($user, $query){
       return $query->where(['Articles.user_id' => $user->getIdentifier()]);
    }
}
