<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Blockedcard $blockedcard
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Blockedcard'), ['action' => 'edit', $blockedcard->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Blockedcard'), ['action' => 'delete', $blockedcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $blockedcard->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Blockedcards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Blockedcard'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="blockedcards view content">
            <h3><?= h($blockedcard->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Customer') ?></th>
                    <td><?= $blockedcard->has('customer') ? $this->Html->link($blockedcard->customer->id, ['controller' => 'Customers', 'action' => 'view', $blockedcard->customer->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Account') ?></th>
                    <td><?= $blockedcard->has('account') ? $this->Html->link($blockedcard->account->id, ['controller' => 'Accounts', 'action' => 'view', $blockedcard->account->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('User') ?></th>
                    <td><?= $blockedcard->has('user') ? $this->Html->link($blockedcard->user->name, ['controller' => 'Users', 'action' => 'view', $blockedcard->user->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Generatedcard') ?></th>
                    <td><?= $blockedcard->has('generatedcard') ? $this->Html->link($blockedcard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $blockedcard->generatedcard->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Card Number') ?></th>
                    <td><?= h($blockedcard->card_number) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($blockedcard->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Date Blocked') ?></th>
                    <td><?= h($blockedcard->date_blocked) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
