<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cardbatch $cardbatch
 * @var string[]|\Cake\Collection\CollectionInterface $requestcards
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $cardbatch->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $cardbatch->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Cardbatches'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="cardbatches form content">
            <?= $this->Form->create($cardbatch) ?>
            <fieldset>
                <legend><?= __('Edit Cardbatch') ?></legend>
                <?php
                    echo $this->Form->control('requestcard_id', ['options' => $requestcards]);
                    echo $this->Form->control('batch_number');
                    echo $this->Form->control('generation_date');
                    echo $this->Form->control('total_cards');
                    echo $this->Form->control('status');
                    echo $this->Form->control('available_count');
                    echo $this->Form->control('delivered');
                    echo $this->Form->control('assigned');
                    echo $this->Form->control('returned');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
