<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Customer $customer
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Customer'), ['action' => 'edit', $customer->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Customer'), ['action' => 'delete', $customer->id], ['confirm' => __('Are you sure you want to delete # {0}?', $customer->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Customers'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Customer'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="customers view content">
            <h3><?= h($customer->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Given Name') ?></th>
                    <td><?= h($customer->given_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Middle Name') ?></th>
                    <td><?= h($customer->middle_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Last Name') ?></th>
                    <td><?= h($customer->last_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Mobile') ?></th>
                    <td><?= h($customer->mobile) ?></td>
                </tr>
                <tr>
                    <th><?= __('Telephone') ?></th>
                    <td><?= h($customer->telephone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email') ?></th>
                    <td><?= h($customer->email) ?></td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= h($customer->status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Civil Status') ?></th>
                    <td><?= h($customer->civil_status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($customer->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Address') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($customer->address)); ?>
                </blockquote>
            </div>
            <div class="related">
                <h4><?= __('Related Accounts') ?></h4>
                <?php if (!empty($customer->accounts)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Customer Id') ?></th>
                            <th><?= __('Branch Id') ?></th>
                            <th><?= __('Account Type') ?></th>
                            <th><?= __('Balance') ?></th>
                            <th><?= __('Account No') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($customer->accounts as $accounts) : ?>
                        <tr>
                            <td><?= h($accounts->id) ?></td>
                            <td><?= h($accounts->customer_id) ?></td>
                            <td><?= h($accounts->branch_id) ?></td>
                            <td><?= h($accounts->account_type) ?></td>
                            <td><?= h($accounts->balance) ?></td>
                            <td><?= h($accounts->account_no) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Accounts', 'action' => 'view', $accounts->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Accounts', 'action' => 'edit', $accounts->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Accounts', 'action' => 'delete', $accounts->id], ['confirm' => __('Are you sure you want to delete # {0}?', $accounts->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Blockedcards') ?></h4>
                <?php if (!empty($customer->blockedcards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Customer Id') ?></th>
                            <th><?= __('Account Id') ?></th>
                            <th><?= __('User Id') ?></th>
                            <th><?= __('Generatedcard Id') ?></th>
                            <th><?= __('Card Number') ?></th>
                            <th><?= __('Date Blocked') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($customer->blockedcards as $blockedcards) : ?>
                        <tr>
                            <td><?= h($blockedcards->id) ?></td>
                            <td><?= h($blockedcards->customer_id) ?></td>
                            <td><?= h($blockedcards->account_id) ?></td>
                            <td><?= h($blockedcards->user_id) ?></td>
                            <td><?= h($blockedcards->generatedcard_id) ?></td>
                            <td><?= h($blockedcards->card_number) ?></td>
                            <td><?= h($blockedcards->date_blocked) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Blockedcards', 'action' => 'view', $blockedcards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Blockedcards', 'action' => 'edit', $blockedcards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Blockedcards', 'action' => 'delete', $blockedcards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $blockedcards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Cards') ?></h4>
                <?php if (!empty($customer->cards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Card Number') ?></th>
                            <th><?= __('Customer Id') ?></th>
                            <th><?= __('Account Id') ?></th>
                            <th><?= __('Generatedcard Id') ?></th>
                            <th><?= __('Expiry Date') ?></th>
                            <th><?= __('Code') ?></th>
                            <th><?= __('Cvv') ?></th>
                            <th><?= __('Is Active') ?></th>
                            <th><?= __('Status') ?></th>
                            <th><?= __('Card Type') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($customer->cards as $cards) : ?>
                        <tr>
                            <td><?= h($cards->id) ?></td>
                            <td><?= h($cards->card_number) ?></td>
                            <td><?= h($cards->customer_id) ?></td>
                            <td><?= h($cards->account_id) ?></td>
                            <td><?= h($cards->generatedcard_id) ?></td>
                            <td><?= h($cards->expiry_date) ?></td>
                            <td><?= h($cards->code) ?></td>
                            <td><?= h($cards->cvv) ?></td>
                            <td><?= h($cards->is_active) ?></td>
                            <td><?= h($cards->status) ?></td>
                            <td><?= h($cards->card_type) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Cards', 'action' => 'view', $cards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Cards', 'action' => 'edit', $cards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Cards', 'action' => 'delete', $cards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $cards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Expiredcards') ?></h4>
                <?php if (!empty($customer->expiredcards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Customer Id') ?></th>
                            <th><?= __('Account Id') ?></th>
                            <th><?= __('User Id') ?></th>
                            <th><?= __('Generatedcard Id') ?></th>
                            <th><?= __('Card Number') ?></th>
                            <th><?= __('Date Expired') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($customer->expiredcards as $expiredcards) : ?>
                        <tr>
                            <td><?= h($expiredcards->id) ?></td>
                            <td><?= h($expiredcards->customer_id) ?></td>
                            <td><?= h($expiredcards->account_id) ?></td>
                            <td><?= h($expiredcards->user_id) ?></td>
                            <td><?= h($expiredcards->generatedcard_id) ?></td>
                            <td><?= h($expiredcards->card_number) ?></td>
                            <td><?= h($expiredcards->date_expired) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Expiredcards', 'action' => 'view', $expiredcards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Expiredcards', 'action' => 'edit', $expiredcards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Expiredcards', 'action' => 'delete', $expiredcards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $expiredcards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Lostcards') ?></h4>
                <?php if (!empty($customer->lostcards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Customer Id') ?></th>
                            <th><?= __('Account Id') ?></th>
                            <th><?= __('Generatedcard Id') ?></th>
                            <th><?= __('Card Number') ?></th>
                            <th><?= __('Date Reported') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($customer->lostcards as $lostcards) : ?>
                        <tr>
                            <td><?= h($lostcards->id) ?></td>
                            <td><?= h($lostcards->customer_id) ?></td>
                            <td><?= h($lostcards->account_id) ?></td>
                            <td><?= h($lostcards->generatedcard_id) ?></td>
                            <td><?= h($lostcards->card_number) ?></td>
                            <td><?= h($lostcards->date_reported) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Lostcards', 'action' => 'view', $lostcards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Lostcards', 'action' => 'edit', $lostcards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Lostcards', 'action' => 'delete', $lostcards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $lostcards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Replacementcards') ?></h4>
                <?php if (!empty($customer->replacementcards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Customer Id') ?></th>
                            <th><?= __('Account Id') ?></th>
                            <th><?= __('Generatedcard Id') ?></th>
                            <th><?= __('From Cardno') ?></th>
                            <th><?= __('To Gen') ?></th>
                            <th><?= __('To Cardno') ?></th>
                            <th><?= __('Replace Date') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($customer->replacementcards as $replacementcards) : ?>
                        <tr>
                            <td><?= h($replacementcards->id) ?></td>
                            <td><?= h($replacementcards->customer_id) ?></td>
                            <td><?= h($replacementcards->account_id) ?></td>
                            <td><?= h($replacementcards->generatedcard_id) ?></td>
                            <td><?= h($replacementcards->from_cardno) ?></td>
                            <td><?= h($replacementcards->to_gen) ?></td>
                            <td><?= h($replacementcards->to_cardno) ?></td>
                            <td><?= h($replacementcards->replace_date) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Replacementcards', 'action' => 'view', $replacementcards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Replacementcards', 'action' => 'edit', $replacementcards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Replacementcards', 'action' => 'delete', $replacementcards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $replacementcards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Stolencards') ?></h4>
                <?php if (!empty($customer->stolencards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Customer Id') ?></th>
                            <th><?= __('Account Id') ?></th>
                            <th><?= __('Generatedcard Id') ?></th>
                            <th><?= __('Card Number') ?></th>
                            <th><?= __('Date Reported') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($customer->stolencards as $stolencards) : ?>
                        <tr>
                            <td><?= h($stolencards->id) ?></td>
                            <td><?= h($stolencards->customer_id) ?></td>
                            <td><?= h($stolencards->account_id) ?></td>
                            <td><?= h($stolencards->generatedcard_id) ?></td>
                            <td><?= h($stolencards->card_number) ?></td>
                            <td><?= h($stolencards->date_reported) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Stolencards', 'action' => 'view', $stolencards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Stolencards', 'action' => 'edit', $stolencards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Stolencards', 'action' => 'delete', $stolencards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $stolencards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
