<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Expiredcard $expiredcard
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Expiredcard'), ['action' => 'edit', $expiredcard->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Expiredcard'), ['action' => 'delete', $expiredcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $expiredcard->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Expiredcards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Expiredcard'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="expiredcards view content">
            <h3><?= h($expiredcard->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Customer') ?></th>
                    <td><?= $expiredcard->has('customer') ? $this->Html->link($expiredcard->customer->id, ['controller' => 'Customers', 'action' => 'view', $expiredcard->customer->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Account') ?></th>
                    <td><?= $expiredcard->has('account') ? $this->Html->link($expiredcard->account->id, ['controller' => 'Accounts', 'action' => 'view', $expiredcard->account->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('User') ?></th>
                    <td><?= $expiredcard->has('user') ? $this->Html->link($expiredcard->user->name, ['controller' => 'Users', 'action' => 'view', $expiredcard->user->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Generatedcard') ?></th>
                    <td><?= $expiredcard->has('generatedcard') ? $this->Html->link($expiredcard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $expiredcard->generatedcard->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Card Number') ?></th>
                    <td><?= h($expiredcard->card_number) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($expiredcard->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Date Expired') ?></th>
                    <td><?= h($expiredcard->date_expired) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
