<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Institution> $institutions
 */
?>
<div class="institutions index content">
    <?= $this->Html->link(__('New Institution'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Institutions') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('name') ?></th>
                    <th><?= $this->Paginator->sort('code') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($institutions as $institution): ?>
                <tr>
                    <td><?= $this->Number->format($institution->id) ?></td>
                    <td><?= h($institution->name) ?></td>
                    <td><?= h($institution->code) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $institution->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $institution->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $institution->id], ['confirm' => __('Are you sure you want to delete # {0}?', $institution->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
