<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Lostcard $lostcard
 * @var \Cake\Collection\CollectionInterface|string[] $customers
 * @var \Cake\Collection\CollectionInterface|string[] $accounts
 * @var \Cake\Collection\CollectionInterface|string[] $generatedcards
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('List Lostcards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="lostcards form content">
            <?= $this->Form->create($lostcard) ?>
            <fieldset>
                <legend><?= __('Add Lostcard') ?></legend>
                <?php
                    echo $this->Form->control('customer_id', ['options' => $customers]);
                    echo $this->Form->control('account_id', ['options' => $accounts]);
                    echo $this->Form->control('generatedcard_id', ['options' => $generatedcards]);
                    echo $this->Form->control('card_number');
                    echo $this->Form->control('date_reported');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
