<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Lostcard $lostcard
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Lostcard'), ['action' => 'edit', $lostcard->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Lostcard'), ['action' => 'delete', $lostcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $lostcard->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Lostcards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Lostcard'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="lostcards view content">
            <h3><?= h($lostcard->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Customer') ?></th>
                    <td><?= $lostcard->has('customer') ? $this->Html->link($lostcard->customer->id, ['controller' => 'Customers', 'action' => 'view', $lostcard->customer->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Account') ?></th>
                    <td><?= $lostcard->has('account') ? $this->Html->link($lostcard->account->id, ['controller' => 'Accounts', 'action' => 'view', $lostcard->account->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Generatedcard') ?></th>
                    <td><?= $lostcard->has('generatedcard') ? $this->Html->link($lostcard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $lostcard->generatedcard->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Card Number') ?></th>
                    <td><?= h($lostcard->card_number) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($lostcard->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Date Reported') ?></th>
                    <td><?= h($lostcard->date_reported) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
