<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Product $product
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Product'), ['action' => 'edit', $product->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Product'), ['action' => 'delete', $product->id], ['confirm' => __('Are you sure you want to delete # {0}?', $product->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Products'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Product'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="products view content">
            <h3><?= h($product->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Institution') ?></th>
                    <td><?= $product->has('institution') ? $this->Html->link($product->institution->name, ['controller' => 'Institutions', 'action' => 'view', $product->institution->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($product->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($product->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Description') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($product->description)); ?>
                </blockquote>
            </div>
            <div class="related">
                <h4><?= __('Related Requestcards') ?></h4>
                <?php if (!empty($product->requestcards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Institution Id') ?></th>
                            <th><?= __('Product Id') ?></th>
                            <th><?= __('Branch Id') ?></th>
                            <th><?= __('User Id') ?></th>
                            <th><?= __('Requested Date') ?></th>
                            <th><?= __('Total Cards') ?></th>
                            <th><?= __('Status') ?></th>
                            <th><?= __('Card Type') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($product->requestcards as $requestcards) : ?>
                        <tr>
                            <td><?= h($requestcards->id) ?></td>
                            <td><?= h($requestcards->institution_id) ?></td>
                            <td><?= h($requestcards->product_id) ?></td>
                            <td><?= h($requestcards->branch_id) ?></td>
                            <td><?= h($requestcards->user_id) ?></td>
                            <td><?= h($requestcards->requested_date) ?></td>
                            <td><?= h($requestcards->total_cards) ?></td>
                            <td><?= h($requestcards->status) ?></td>
                            <td><?= h($requestcards->card_type) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Requestcards', 'action' => 'view', $requestcards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Requestcards', 'action' => 'edit', $requestcards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Requestcards', 'action' => 'delete', $requestcards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $requestcards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
