<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Replacementcard $replacementcard
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Replacementcard'), ['action' => 'edit', $replacementcard->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Replacementcard'), ['action' => 'delete', $replacementcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $replacementcard->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Replacementcards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Replacementcard'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="replacementcards view content">
            <h3><?= h($replacementcard->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Customer') ?></th>
                    <td><?= $replacementcard->has('customer') ? $this->Html->link($replacementcard->customer->id, ['controller' => 'Customers', 'action' => 'view', $replacementcard->customer->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Account') ?></th>
                    <td><?= $replacementcard->has('account') ? $this->Html->link($replacementcard->account->id, ['controller' => 'Accounts', 'action' => 'view', $replacementcard->account->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Generatedcard') ?></th>
                    <td><?= $replacementcard->has('generatedcard') ? $this->Html->link($replacementcard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $replacementcard->generatedcard->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('From Cardno') ?></th>
                    <td><?= h($replacementcard->from_cardno) ?></td>
                </tr>
                <tr>
                    <th><?= __('To Cardno') ?></th>
                    <td><?= h($replacementcard->to_cardno) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($replacementcard->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('To Gen') ?></th>
                    <td><?= $this->Number->format($replacementcard->to_gen) ?></td>
                </tr>
                <tr>
                    <th><?= __('Replace Date') ?></th>
                    <td><?= h($replacementcard->replace_date) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
