<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Requestcard> $requestcards
 */
?>
<div class="requestcards index content">
    <?= $this->Html->link(__('New Requestcard'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Requestcards') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('institution_id') ?></th>
                    <th><?= $this->Paginator->sort('product_id') ?></th>
                    <th><?= $this->Paginator->sort('branch_id') ?></th>
                    <th><?= $this->Paginator->sort('user_id') ?></th>
                    <th><?= $this->Paginator->sort('requested_date') ?></th>
                    <th><?= $this->Paginator->sort('total_cards') ?></th>
                    <th><?= $this->Paginator->sort('status') ?></th>
                    <th><?= $this->Paginator->sort('card_type') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($requestcards as $requestcard): ?>
                <tr>
                    <td><?= $this->Number->format($requestcard->id) ?></td>
                    <td><?= $requestcard->has('institution') ? $this->Html->link($requestcard->institution->name, ['controller' => 'Institutions', 'action' => 'view', $requestcard->institution->id]) : '' ?></td>
                    <td><?= $requestcard->has('product') ? $this->Html->link($requestcard->product->name, ['controller' => 'Products', 'action' => 'view', $requestcard->product->id]) : '' ?></td>
                    <td><?= $requestcard->has('branch') ? $this->Html->link($requestcard->branch->name, ['controller' => 'Branches', 'action' => 'view', $requestcard->branch->id]) : '' ?></td>
                    <td><?= $requestcard->has('user') ? $this->Html->link($requestcard->user->name, ['controller' => 'Users', 'action' => 'view', $requestcard->user->id]) : '' ?></td>
                    <td><?= h($requestcard->requested_date) ?></td>
                    <td><?= $this->Number->format($requestcard->total_cards) ?></td>
                    <td><?= h($requestcard->status) ?></td>
                    <td><?= h($requestcard->card_type) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $requestcard->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $requestcard->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $requestcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $requestcard->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
