<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Requestcard $requestcard
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Requestcard'), ['action' => 'edit', $requestcard->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Requestcard'), ['action' => 'delete', $requestcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $requestcard->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Requestcards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Requestcard'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="requestcards view content">
            <h3><?= h($requestcard->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Institution') ?></th>
                    <td><?= $requestcard->has('institution') ? $this->Html->link($requestcard->institution->name, ['controller' => 'Institutions', 'action' => 'view', $requestcard->institution->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Product') ?></th>
                    <td><?= $requestcard->has('product') ? $this->Html->link($requestcard->product->name, ['controller' => 'Products', 'action' => 'view', $requestcard->product->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Branch') ?></th>
                    <td><?= $requestcard->has('branch') ? $this->Html->link($requestcard->branch->name, ['controller' => 'Branches', 'action' => 'view', $requestcard->branch->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('User') ?></th>
                    <td><?= $requestcard->has('user') ? $this->Html->link($requestcard->user->name, ['controller' => 'Users', 'action' => 'view', $requestcard->user->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= h($requestcard->status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Card Type') ?></th>
                    <td><?= h($requestcard->card_type) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($requestcard->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Total Cards') ?></th>
                    <td><?= $this->Number->format($requestcard->total_cards) ?></td>
                </tr>
                <tr>
                    <th><?= __('Requested Date') ?></th>
                    <td><?= h($requestcard->requested_date) ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Cardbatches') ?></h4>
                <?php if (!empty($requestcard->cardbatches)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Requestcard Id') ?></th>
                            <th><?= __('Batch Number') ?></th>
                            <th><?= __('Generation Date') ?></th>
                            <th><?= __('Total Cards') ?></th>
                            <th><?= __('Status') ?></th>
                            <th><?= __('Available Count') ?></th>
                            <th><?= __('Delivered') ?></th>
                            <th><?= __('Assigned') ?></th>
                            <th><?= __('Returned') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($requestcard->cardbatches as $cardbatches) : ?>
                        <tr>
                            <td><?= h($cardbatches->id) ?></td>
                            <td><?= h($cardbatches->requestcard_id) ?></td>
                            <td><?= h($cardbatches->batch_number) ?></td>
                            <td><?= h($cardbatches->generation_date) ?></td>
                            <td><?= h($cardbatches->total_cards) ?></td>
                            <td><?= h($cardbatches->status) ?></td>
                            <td><?= h($cardbatches->available_count) ?></td>
                            <td><?= h($cardbatches->delivered) ?></td>
                            <td><?= h($cardbatches->assigned) ?></td>
                            <td><?= h($cardbatches->returned) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Cardbatches', 'action' => 'view', $cardbatches->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Cardbatches', 'action' => 'edit', $cardbatches->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Cardbatches', 'action' => 'delete', $cardbatches->id], ['confirm' => __('Are you sure you want to delete # {0}?', $cardbatches->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
